package de.bebagoe.util.coll;

import java.util.Arrays;

public class SimpleList<E> {
    private Object[] elements;
    private final static int DEF_INIT_SIZE = 16;
    private int initSize;
    private int size;
	
	public SimpleList(int len) {
        if (len <= 0)
            throw new IllegalArgumentException("Die initiale Größe muss positiv sein.");
        initSize = len;
        elements = new Object[len];
        super();
	}

	public SimpleList() {
        initSize = DEF_INIT_SIZE;
        elements = new Object[DEF_INIT_SIZE];
        super();
	}

	public void add(E element) {
		if (size == elements.length)
			elements = Arrays.copyOf(elements, elements.length + initSize);
		elements[size++] = element;
	}

	// Casting erforderlich, weil kein Array vom Typ E erstellt werden.
	// elements kann nur Objekte vom Typ E enthalten.
    @SuppressWarnings("unchecked")
	public E get(int index) {
		if (index >= 0 && index < size)
			return (E) elements[index];
		else
			return null;
	}

//	public void addList(SimpleList<E> list) {
//		if (size + list.size > elements.length)
//			elements = Arrays.copyOf(elements, size + list.size + initSize);
//		for (int i = 0; i < list.size; i++)
//			elements[size++] = list.get(i);
//	}

	// Ein nach oben restringierter Wildcard-Typ ermöglicht die Verarbeitung einer SimpleList<E> -
	// Konkretisierung mit dem Typ E oder einer Ableitung.
	public void addList(SimpleList<? extends E> list) {
		if (size + list.size > elements.length)
			elements = Arrays.copyOf(elements, size + list.size + initSize);
		for (int i = 0; i < list.size; i++)
			elements[size++] = list.get(i);
	}

//	public void copyElements(SimpleList<E> list) {
//		for (int i = 0; i < size; i++)
//			list.add((E) elements[i]);
//	}

	// Casting erforderlich, weil kein Array vom Typ E erstellt werden.
    // elements kann nur Objekte vom Typ E enthalten.
	@SuppressWarnings("unchecked")
	public void copyElements(SimpleList<? super E> list) {
		for (int i = 0; i < size; i++)
			list.add((E) elements[i]);
	}
	
	public int size() {return size;}

	public int capacity() {return elements.length;}
}